// Envoi de message
$("#submit").click(function () {
    const object = {
        nom: $("#name").val(),
        objet: $("#msg_subject").val(),
        emailFrom: $("#email").val(),
        message: $("#message").val()
    };
    if (object.nom !== '' && object.objet !== '' && object.emailFrom !== '' && object.message !== '') {
        validateEmail(object);
    } else {
        showWarnMessage("Veuillez renseignez tous les champs");
    }
});

function sendMessage(data) {
    const httpClient = new XMLHttpRequest();
    const url = 'https://sikabdigital.com/api/send-email';
    // const url = 'http://localhost:2023/api/send-email';
    httpClient.open('POST', url);
    httpClient.setRequestHeader("Content-Type", "application/json;charset=UTF-8");
    httpClient.onreadystatechange = () => {
        if (httpClient.status === 200 && httpClient.readyState === 4) {
            document.getElementById("contactForm").reset();
            showSuccesMessage();
        }
    }
    httpClient.send(JSON.stringify(data));
}

function showSuccesMessage() {
    saberToast.success({
        title: "INFORMATION",
        text: "Message bien envoyé",
        delay: 200,
        duration: 2600,
        rtl: false,
        position: "bottom-right"
    });
}

function showWarnMessage(message) {
    saberToast.warn({
        title: "INFORMATION",
        text: message,
        delay: 200,
        duration: 2600,
        rtl: false,
        position: "bottom-right"
    });
}

function validateEmail(data) {
    const  validRegex = /^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9-]+(?:\.[a-zA-Z0-9-]+)*$/;
    if (data.emailFrom.match(validRegex)) {
        sendMessage(data);
    } else {
        showWarnMessage("Adresse email invalide");
    }
}

